/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1alpha1 "k8s.io/api/resource/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	resourcev1alpha1 "k8s.io/client-go/applyconfigurations/resource/v1alpha1"
	testing "k8s.io/client-go/testing"
)

// FakePodSchedulings implements PodSchedulingInterface
type FakePodSchedulings struct {
	Fake *FakeResourceV1alpha1
	ns   string
}

var podschedulingsResource = v1alpha1.SchemeGroupVersion.WithResource("podschedulings")

var podschedulingsKind = v1alpha1.SchemeGroupVersion.WithKind("PodScheduling")

// Get takes name of the podScheduling, and returns the corresponding podScheduling object, and an error if there is any.
func (c *FakePodSchedulings) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.PodScheduling, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(podschedulingsResource, c.ns, name), &v1alpha1.PodScheduling{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.PodScheduling), err
}

// List takes label and field selectors, and returns the list of PodSchedulings that match those selectors.
func (c *FakePodSchedulings) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.PodSchedulingList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(podschedulingsResource, podschedulingsKind, c.ns, opts), &v1alpha1.PodSchedulingList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.PodSchedulingList{ListMeta: obj.(*v1alpha1.PodSchedulingList).ListMeta}
	for _, item := range obj.(*v1alpha1.PodSchedulingList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested podSchedulings.
func (c *FakePodSchedulings) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(podschedulingsResource, c.ns, opts))

}

// Create takes the representation of a podScheduling and creates it.  Returns the server's representation of the podScheduling, and an error, if there is any.
func (c *FakePodSchedulings) Create(ctx context.Context, podScheduling *v1alpha1.PodScheduling, opts v1.CreateOptions) (result *v1alpha1.PodScheduling, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(podschedulingsResource, c.ns, podScheduling), &v1alpha1.PodScheduling{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.PodScheduling), err
}

// Update takes the representation of a podScheduling and updates it. Returns the server's representation of the podScheduling, and an error, if there is any.
func (c *FakePodSchedulings) Update(ctx context.Context, podScheduling *v1alpha1.PodScheduling, opts v1.UpdateOptions) (result *v1alpha1.PodScheduling, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(podschedulingsResource, c.ns, podScheduling), &v1alpha1.PodScheduling{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.PodScheduling), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakePodSchedulings) UpdateStatus(ctx context.Context, podScheduling *v1alpha1.PodScheduling, opts v1.UpdateOptions) (*v1alpha1.PodScheduling, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(podschedulingsResource, "status", c.ns, podScheduling), &v1alpha1.PodScheduling{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.PodScheduling), err
}

// Delete takes name of the podScheduling and deletes it. Returns an error if one occurs.
func (c *FakePodSchedulings) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(podschedulingsResource, c.ns, name, opts), &v1alpha1.PodScheduling{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakePodSchedulings) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(podschedulingsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.PodSchedulingList{})
	return err
}

// Patch applies the patch and returns the patched podScheduling.
func (c *FakePodSchedulings) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.PodScheduling, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(podschedulingsResource, c.ns, name, pt, data, subresources...), &v1alpha1.PodScheduling{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.PodScheduling), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied podScheduling.
func (c *FakePodSchedulings) Apply(ctx context.Context, podScheduling *resourcev1alpha1.PodSchedulingApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.PodScheduling, err error) {
	if podScheduling == nil {
		return nil, fmt.Errorf("podScheduling provided to Apply must not be nil")
	}
	data, err := json.Marshal(podScheduling)
	if err != nil {
		return nil, err
	}
	name := podScheduling.Name
	if name == nil {
		return nil, fmt.Errorf("podScheduling.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(podschedulingsResource, c.ns, *name, types.ApplyPatchType, data), &v1alpha1.PodScheduling{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.PodScheduling), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakePodSchedulings) ApplyStatus(ctx context.Context, podScheduling *resourcev1alpha1.PodSchedulingApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.PodScheduling, err error) {
	if podScheduling == nil {
		return nil, fmt.Errorf("podScheduling provided to Apply must not be nil")
	}
	data, err := json.Marshal(podScheduling)
	if err != nil {
		return nil, err
	}
	name := podScheduling.Name
	if name == nil {
		return nil, fmt.Errorf("podScheduling.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(podschedulingsResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1alpha1.PodScheduling{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.PodScheduling), err
}
